package io.k8s.api.batch.v1beta1

/* CronJobSpec describes how the job execution will look like and when it will actually run. */
import io.circe._
import io.circe.generic.semiauto._

case class CronJobSpec(
  /* The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron. */
  schedule: String,
  /* Specifies the job that will be created when executing a CronJob. */
  jobTemplate: io.k8s.api.batch.v1beta1.JobTemplateSpec,
  /* Specifies how to treat concurrent executions of a Job. Valid values are: - "Allow" (default): allows CronJobs to run concurrently; - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - "Replace": cancels currently running job and replaces it with a new one */
  concurrencyPolicy: Option[String] = None,
  /* The number of failed finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1. */
  failedJobsHistoryLimit: Option[Int] = None,
  /* Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones. */
  startingDeadlineSeconds: Option[Long] = None,
  /* The number of successful finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified. Defaults to 3. */
  successfulJobsHistoryLimit: Option[Int] = None,
  /* This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false. */
  suspend: Option[Boolean] = None
)

object CronJobSpec {
  implicit lazy val encoder: Encoder.AsObject[CronJobSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[CronJobSpec] = deriveDecoder
}
