package io.k8s.api.batch.v1

/* CronJobStatus represents the current state of a cron job. */
import io.circe._
import io.circe.generic.semiauto._

case class CronJobStatus(
  /* A list of pointers to currently running jobs. */
  active: Option[Seq[io.k8s.api.core.v1.ObjectReference]] = None,
  /* Information when was the last time the job was successfully scheduled. */
  lastScheduleTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* Information when was the last time the job successfully completed. */
  lastSuccessfulTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
)

object CronJobStatus {
  implicit lazy val encoder: Encoder.AsObject[CronJobStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[CronJobStatus] = deriveDecoder
}
