package io.k8s.api.autoscaling.v1

/* CrossVersionObjectReference contains enough information to let you identify the referred resource. */
import io.circe._
import io.circe.generic.semiauto._

case class CrossVersionObjectReference(
  /* Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds" */
  kind: String,
  /* Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names */
  name: String,
  /* API version of the referent */
  apiVersion: Option[String] = None
)

object CrossVersionObjectReference {
  implicit lazy val encoder: Encoder.AsObject[CrossVersionObjectReference] = deriveEncoder
  implicit lazy val decoder: Decoder[CrossVersionObjectReference] = deriveDecoder
}
