package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

/* CustomResourceDefinitionCondition contains details for the current condition of this pod. */
import io.circe._
import io.circe.generic.semiauto._

case class CustomResourceDefinitionCondition(
  /* type is the type of the condition. Types include Established, NamesAccepted and Terminating. */
  `type`: String,
  /* status is the status of the condition. Can be True, False, Unknown. */
  status: String,
  /* lastTransitionTime last time the condition transitioned from one status to another. */
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* message is a human-readable message indicating details about last transition. */
  message: Option[String] = None,
  /* reason is a unique, one-word, CamelCase reason for the condition's last transition. */
  reason: Option[String] = None
)

object CustomResourceDefinitionCondition {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceDefinitionCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceDefinitionCondition] = deriveDecoder
}
