package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

/* CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition */
import io.circe._
import io.circe.generic.semiauto._

case class CustomResourceDefinitionNames(
  /* plural is the plural name of the resource to serve. The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase. */
  plural: String,
  /* kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls. */
  kind: String,
  /* categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`. */
  categories: Option[Seq[String]] = None,
  /* listKind is the serialized kind of the list for this resource. Defaults to "`kind`List". */
  listKind: Option[String] = None,
  /* shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`. It must be all lowercase. */
  shortNames: Option[Seq[String]] = None,
  /* singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`. */
  singular: Option[String] = None
)

object CustomResourceDefinitionNames {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceDefinitionNames] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceDefinitionNames] = deriveDecoder
}
