package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

/* CustomResourceDefinitionVersion describes a version for CRD. */
import io.circe._
import io.circe.generic.semiauto._

case class CustomResourceDefinitionVersion(
  /* name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true. */
  name: String,
  /* served is a flag enabling/disabling this version from being served via REST APIs */
  served: Boolean,
  /* storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true. */
  storage: Boolean,
  /* additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used. */
  additionalPrinterColumns: Option[Seq[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition]] = None,
  /* deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false. */
  deprecated: Option[Boolean] = None,
  /* deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists. */
  deprecationWarning: Option[String] = None,
  /* schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource. */
  schema: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceValidation] = None,
  /* subresources specify what subresources this version of the defined custom resource have. */
  subresources: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources] = None
)

object CustomResourceDefinitionVersion {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceDefinitionVersion] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceDefinitionVersion] = deriveDecoder
}
