package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

/* CustomResourceSubresources defines the status and scale subresources for CustomResources. */
import io.circe._
import io.circe.generic.semiauto._

case class CustomResourceSubresources(
  /* scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object. */
  scale: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale] = None,
  /* status indicates the custom resource should serve a `/status` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object. 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object. */
  status: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceStatus] = None
)

object CustomResourceSubresources {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceSubresources] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceSubresources] = deriveDecoder
}
