package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

/* CustomResourceValidation is a list of validation methods for CustomResources. */
import io.circe._
import io.circe.generic.semiauto._

case class CustomResourceValidation(
  /* openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning. */
  openAPIV3Schema: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = None
)

object CustomResourceValidation {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceValidation] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceValidation] = deriveDecoder
}
