package io.k8s.api.apps.v1

/* DaemonSetStatus represents the current status of a daemon set. */
import io.circe._
import io.circe.generic.semiauto._

case class DaemonSetStatus(
  /* The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/ */
  currentNumberScheduled: Int,
  /* The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/ */
  numberMisscheduled: Int,
  /* The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/ */
  desiredNumberScheduled: Int,
  /* The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready. */
  numberReady: Int,
  /* Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision. */
  collisionCount: Option[Int] = None,
  /* Represents the latest available observations of a DaemonSet's current state. */
  conditions: Option[Seq[io.k8s.api.apps.v1.DaemonSetCondition]] = None,
  /* The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds) */
  numberAvailable: Option[Int] = None,
  /* The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds) */
  numberUnavailable: Option[Int] = None,
  /* The most recent generation observed by the daemon set controller. */
  observedGeneration: Option[Long] = None,
  /* The total number of nodes that are running updated daemon pod */
  updatedNumberScheduled: Option[Int] = None
)

object DaemonSetStatus {
  implicit lazy val encoder: Encoder.AsObject[DaemonSetStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[DaemonSetStatus] = deriveDecoder
}
