package io.k8s.api.apps.v1

/* Deployment enables declarative updates for Pods and ReplicaSets. */
import io.circe._
import io.circe.generic.semiauto._

case class Deployment(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard object metadata. */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* Specification of the desired behavior of the Deployment. */
  spec: Option[io.k8s.api.apps.v1.DeploymentSpec] = None,
  /* Most recently observed status of the Deployment. */
  status: Option[io.k8s.api.apps.v1.DeploymentStatus] = None
)

object Deployment {
  implicit lazy val encoder: Encoder.AsObject[Deployment] = deriveEncoder
  implicit lazy val decoder: Decoder[Deployment] = deriveDecoder
}
