package io.k8s.api.apps.v1

/* DeploymentStrategy describes how to replace existing pods with new ones. */
import io.circe._
import io.circe.generic.semiauto._

case class DeploymentStrategy(
  /* Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate. */
  rollingUpdate: Option[io.k8s.api.apps.v1.RollingUpdateDeployment] = None,
  /* Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate. */
  `type`: Option[String] = None
)

object DeploymentStrategy {
  implicit lazy val encoder: Encoder.AsObject[DeploymentStrategy] = deriveEncoder
  implicit lazy val decoder: Decoder[DeploymentStrategy] = deriveDecoder
}
