package io.k8s.api.core.v1

/* Represents downward API info for projecting into a projected volume. Note that this is identical to a downwardAPI volume source without the default mode. */
import io.circe._
import io.circe.generic.semiauto._

case class DownwardAPIProjection(
  /* Items is a list of DownwardAPIVolume file */
  items: Option[Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]] = None
)

object DownwardAPIProjection {
  implicit lazy val encoder: Encoder.AsObject[DownwardAPIProjection] = deriveEncoder
  implicit lazy val decoder: Decoder[DownwardAPIProjection] = deriveDecoder
}
