package io.k8s.api.core.v1

/* EndpointAddress is a tuple that describes single IP address. */
import io.circe._
import io.circe.generic.semiauto._

case class EndpointAddress(
  /* The IP of this endpoint. May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready. */
  ip: String,
  /* The Hostname of this endpoint */
  hostname: Option[String] = None,
  /* Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node. */
  nodeName: Option[String] = None,
  /* Reference to object providing the endpoint. */
  targetRef: Option[io.k8s.api.core.v1.ObjectReference] = None
)

object EndpointAddress {
  implicit lazy val encoder: Encoder.AsObject[EndpointAddress] = deriveEncoder
  implicit lazy val decoder: Decoder[EndpointAddress] = deriveDecoder
}
