package io.k8s.api.core.v1

/* EnvVarSource represents a source for the value of an EnvVar. */
import io.circe._
import io.circe.generic.semiauto._

case class EnvVarSource(
  /* Selects a key of a ConfigMap. */
  configMapKeyRef: Option[io.k8s.api.core.v1.ConfigMapKeySelector] = None,
  /* Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs. */
  fieldRef: Option[io.k8s.api.core.v1.ObjectFieldSelector] = None,
  /* Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported. */
  resourceFieldRef: Option[io.k8s.api.core.v1.ResourceFieldSelector] = None,
  /* Selects a key of a secret in the pod's namespace */
  secretKeyRef: Option[io.k8s.api.core.v1.SecretKeySelector] = None
)

object EnvVarSource {
  implicit lazy val encoder: Encoder.AsObject[EnvVarSource] = deriveEncoder
  implicit lazy val decoder: Decoder[EnvVarSource] = deriveDecoder
}
