package io.k8s.api.core.v1

/* A list of ephemeral containers used with the Pod ephemeralcontainers subresource. */
import io.circe._
import io.circe.generic.semiauto._

case class EphemeralContainers(
  /* A list of ephemeral containers associated with this pod. New ephemeral containers may be appended to this list, but existing ephemeral containers may not be removed or modified. */
  ephemeralContainers: Seq[io.k8s.api.core.v1.EphemeralContainer],
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
)

object EphemeralContainers {
  implicit lazy val encoder: Encoder.AsObject[EphemeralContainers] = deriveEncoder
  implicit lazy val decoder: Decoder[EphemeralContainers] = deriveDecoder
}
