package io.k8s.api.core.v1

/* Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data. */
import io.circe._
import io.circe.generic.semiauto._

case class Event(
  /* Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata */
  metadata: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta,
  /* The object that this event is about. */
  involvedObject: io.k8s.api.core.v1.ObjectReference,
  /* What action was taken/failed regarding to the Regarding object. */
  action: Option[String] = None,
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* The number of times this event has occurred. */
  count: Option[Int] = None,
  /* Time when this Event was first observed. */
  eventTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None,
  /* The time at which the event was first recorded. (Time of server receipt is in TypeMeta.) */
  firstTimestamp: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* The time at which the most recent occurrence of this event was recorded. */
  lastTimestamp: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* A human-readable description of the status of this operation. */
  message: Option[String] = None,
  /* This should be a short, machine understandable string that gives the reason for the transition into the object's current status. */
  reason: Option[String] = None,
  /* Optional secondary object for more complex actions. */
  related: Option[io.k8s.api.core.v1.ObjectReference] = None,
  /* Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`. */
  reportingComponent: Option[String] = None,
  /* ID of the controller instance, e.g. `kubelet-xyzf`. */
  reportingInstance: Option[String] = None,
  /* Data about the Event series this event represents or nil if it's a singleton Event. */
  series: Option[io.k8s.api.core.v1.EventSeries] = None,
  /* The component reporting this event. Should be a short machine understandable string. */
  source: Option[io.k8s.api.core.v1.EventSource] = None,
  /* Type of this event (Normal, Warning), new types could be added in the future */
  `type`: Option[String] = None
)

object Event {
  implicit lazy val encoder: Encoder.AsObject[Event] = deriveEncoder
  implicit lazy val decoder: Decoder[Event] = deriveDecoder
}
