package io.k8s.api.core.v1

/* EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time. */
import io.circe._
import io.circe.generic.semiauto._

case class EventSeries(
  /* Number of occurrences in this series up to the last heartbeat time */
  count: Option[Int] = None,
  /* Time of the last occurrence observed */
  lastObservedTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None
)

object EventSeries {
  implicit lazy val encoder: Encoder.AsObject[EventSeries] = deriveEncoder
  implicit lazy val decoder: Decoder[EventSeries] = deriveDecoder
}
