package io.k8s.api.core.v1

/* FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. */
import io.circe._
import io.circe.generic.semiauto._

case class FlexVolumeSource(
  /* Driver is the name of the driver to use for this volume. */
  driver: String,
  /* Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script. */
  fsType: Option[String] = None,
  /* Optional: Extra command options if any. */
  options: Option[Map[String, String]] = None,
  /* Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. */
  readOnly: Option[Boolean] = None,
  /* Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts. */
  secretRef: Option[io.k8s.api.core.v1.LocalObjectReference] = None
)

object FlexVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[FlexVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[FlexVolumeSource] = deriveDecoder
}
