package io.k8s.api.core.v1

/* Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.

DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container. */
import io.circe._
import io.circe.generic.semiauto._

case class GitRepoVolumeSource(
  /* Repository URL */
  repository: String,
  /* Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name. */
  directory: Option[String] = None,
  /* Commit hash for the specified revision. */
  revision: Option[String] = None
)

object GitRepoVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[GitRepoVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[GitRepoVolumeSource] = deriveDecoder
}
