package io.k8s.apimachinery.pkg.apis.meta.v1

/* GroupVersion contains the "group/version" and "version" string of a version. It is made a struct to keep extensibility. */
import io.circe._
import io.circe.generic.semiauto._

case class GroupVersionForDiscovery(
  /* groupVersion specifies the API group and version in the form "group/version" */
  groupVersion: String,
  /* version specifies the version in the form of "version". This is to save the clients the trouble of splitting the GroupVersion. */
  version: String
)

object GroupVersionForDiscovery {
  implicit lazy val encoder: Encoder.AsObject[GroupVersionForDiscovery] = deriveEncoder
  implicit lazy val decoder: Decoder[GroupVersionForDiscovery] = deriveDecoder
}
