package io.k8s.api.core.v1

/* HTTPHeader describes a custom header to be used in HTTP probes */
import io.circe._
import io.circe.generic.semiauto._

case class HTTPHeader(
  /* The header field name */
  name: String,
  /* The header field value */
  value: String
)

object HTTPHeader {
  implicit lazy val encoder: Encoder.AsObject[HTTPHeader] = deriveEncoder
  implicit lazy val decoder: Decoder[HTTPHeader] = deriveDecoder
}
