package io.k8s.api.networking.v1beta1

/* HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'. */
import io.circe._
import io.circe.generic.semiauto._

case class HTTPIngressRuleValue(
  /* A collection of paths that map requests to backends. */
  paths: Seq[io.k8s.api.networking.v1beta1.HTTPIngressPath]
)

object HTTPIngressRuleValue {
  implicit lazy val encoder: Encoder.AsObject[HTTPIngressRuleValue] = deriveEncoder
  implicit lazy val decoder: Decoder[HTTPIngressRuleValue] = deriveDecoder
}
