package io.k8s.api.autoscaling.v1

/* configuration of a horizontal pod autoscaler. */
import io.circe._
import io.circe.generic.semiauto._

case class HorizontalPodAutoscaler(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* behaviour of autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. */
  spec: Option[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec] = None,
  /* current information about the autoscaler. */
  status: Option[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus] = None
)

object HorizontalPodAutoscaler {
  implicit lazy val encoder: Encoder.AsObject[HorizontalPodAutoscaler] = deriveEncoder
  implicit lazy val decoder: Decoder[HorizontalPodAutoscaler] = deriveDecoder
}
