package io.k8s.api.core.v1

/* Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling. */
import io.circe._
import io.circe.generic.semiauto._

case class HostPathVolumeSource(
  /* Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath */
  path: String,
  /* Type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath */
  `type`: Option[String] = None
)

object HostPathVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[HostPathVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[HostPathVolumeSource] = deriveDecoder
}
