package io.k8s.api.policy.v1beta1

/* IDRange provides a min/max of an allowed range of IDs. */
import io.circe._
import io.circe.generic.semiauto._

case class IDRange(
  /* min is the start of the range, inclusive. */
  min: Long,
  /* max is the end of the range, inclusive. */
  max: Long
)

object IDRange {
  implicit lazy val encoder: Encoder.AsObject[IDRange] = deriveEncoder
  implicit lazy val decoder: Decoder[IDRange] = deriveDecoder
}
