package io.k8s.api.networking.v1

/* IPBlock describes a particular CIDR (Ex. "192.168.1.1/24","2001:db9::/64") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule. */
import io.circe._
import io.circe.generic.semiauto._

case class IPBlock(
  /* CIDR is a string representing the IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64" */
  cidr: String,
  /* Except is a slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64" Except values will be rejected if they are outside the CIDR range */
  except: Option[Seq[String]] = None
)

object IPBlock {
  implicit lazy val encoder: Encoder.AsObject[IPBlock] = deriveEncoder
  implicit lazy val decoder: Decoder[IPBlock] = deriveDecoder
}
