package io.k8s.api.core.v1

/* Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling. */
import io.circe._
import io.circe.generic.semiauto._

case class ISCSIVolumeSource(
  /* iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260). */
  targetPortal: String,
  /* Target iSCSI Qualified Name. */
  iqn: String,
  /* iSCSI Target Lun number. */
  lun: Int,
  /* whether support iSCSI Discovery CHAP authentication */
  chapAuthDiscovery: Option[Boolean] = None,
  /* whether support iSCSI Session CHAP authentication */
  chapAuthSession: Option[Boolean] = None,
  /* Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi */
  fsType: Option[String] = None,
  /* Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection. */
  initiatorName: Option[String] = None,
  /* iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp). */
  iscsiInterface: Option[String] = None,
  /* iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260). */
  portals: Option[Seq[String]] = None,
  /* ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. */
  readOnly: Option[Boolean] = None,
  /* CHAP Secret for iSCSI target and initiator authentication */
  secretRef: Option[io.k8s.api.core.v1.LocalObjectReference] = None
)

object ISCSIVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[ISCSIVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[ISCSIVolumeSource] = deriveDecoder
}
