package io.k8s.api.networking.v1beta1

/* IngressClassParametersReference identifies an API object. This can be used to specify a cluster or namespace-scoped resource. */
import io.circe._
import io.circe.generic.semiauto._

case class IngressClassParametersReference(
  /* Kind is the type of resource being referenced. */
  kind: String,
  /* Name is the name of resource being referenced. */
  name: String,
  /* APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required. */
  apiGroup: Option[String] = None,
  /* Namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster". */
  namespace: Option[String] = None,
  /* Scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace". Field can be enabled with IngressClassNamespacedParams feature gate. */
  scope: Option[String] = None
)

object IngressClassParametersReference {
  implicit lazy val encoder: Encoder.AsObject[IngressClassParametersReference] = deriveEncoder
  implicit lazy val decoder: Decoder[IngressClassParametersReference] = deriveDecoder
}
