package io.k8s.api.networking.v1

/* IngressServiceBackend references a Kubernetes Service as a Backend. */
import io.circe._
import io.circe.generic.semiauto._

case class IngressServiceBackend(
  /* Name is the referenced service. The service must exist in the same namespace as the Ingress object. */
  name: String,
  /* Port of the referenced service. A port name or port number is required for a IngressServiceBackend. */
  port: Option[io.k8s.api.networking.v1.ServiceBackendPort] = None
)

object IngressServiceBackend {
  implicit lazy val encoder: Encoder.AsObject[IngressServiceBackend] = deriveEncoder
  implicit lazy val decoder: Decoder[IngressServiceBackend] = deriveDecoder
}
