package io.k8s.api.networking.v1

/* IngressStatus describe the current state of the Ingress. */
import io.circe._
import io.circe.generic.semiauto._

case class IngressStatus(
  /* LoadBalancer contains the current status of the load-balancer. */
  loadBalancer: Option[io.k8s.api.core.v1.LoadBalancerStatus] = None
)

object IngressStatus {
  implicit lazy val encoder: Encoder.AsObject[IngressStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[IngressStatus] = deriveDecoder
}
