package io.k8s.api.core.v1

/* LimitRangeItem defines a min/max usage limit for any resource that matches on kind. */
import io.circe._
import io.circe.generic.semiauto._

case class LimitRangeItem(
  /* Type of resource that this limit applies to. */
  `type`: String,
  /* Default resource requirement limit value by resource name if resource limit is omitted. */
  default: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  /* DefaultRequest is the default resource requirement request value by resource name if resource request is omitted. */
  defaultRequest: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  /* Max usage constraints on this kind by resource name. */
  max: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  /* MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource. */
  maxLimitRequestRatio: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  /* Min usage constraints on this kind by resource name. */
  min: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
)

object LimitRangeItem {
  implicit lazy val encoder: Encoder.AsObject[LimitRangeItem] = deriveEncoder
  implicit lazy val decoder: Decoder[LimitRangeItem] = deriveDecoder
}
