package io.k8s.api.core.v1

/* Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling. */
import io.circe._
import io.circe.generic.semiauto._

case class NFSVolumeSource(
  /* Server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs */
  server: String,
  /* Path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs */
  path: String,
  /* ReadOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs */
  readOnly: Option[Boolean] = None
)

object NFSVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[NFSVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[NFSVolumeSource] = deriveDecoder
}
