package io.k8s.api.core.v1

/* NamespaceCondition contains details about state of namespace. */
import io.circe._
import io.circe.generic.semiauto._

case class NamespaceCondition(
  /* Type of namespace controller condition. */
  `type`: String,
  /* Status of the condition, one of True, False, Unknown. */
  status: String,
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None
)

object NamespaceCondition {
  implicit lazy val encoder: Encoder.AsObject[NamespaceCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[NamespaceCondition] = deriveDecoder
}
