package io.k8s.api.core.v1

/* NamespaceStatus is information about the current status of a Namespace. */
import io.circe._
import io.circe.generic.semiauto._

case class NamespaceStatus(
  /* Represents the latest available observations of a namespace's current state. */
  conditions: Option[Seq[io.k8s.api.core.v1.NamespaceCondition]] = None,
  /* Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/ */
  phase: Option[String] = None
)

object NamespaceStatus {
  implicit lazy val encoder: Encoder.AsObject[NamespaceStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[NamespaceStatus] = deriveDecoder
}
