package io.k8s.api.networking.v1

/* NetworkPolicyPort describes a port to allow traffic on */
import io.circe._
import io.circe.generic.semiauto._

case class NetworkPolicyPort(
  /* If set, indicates that the range of ports from port to endPort, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port. This feature is in Alpha state and should be enabled using the Feature Gate "NetworkPolicyEndPort". */
  endPort: Option[Int] = None,
  /* The port on the given protocol. This can either be a numerical or named port on a pod. If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched. */
  port: Option[com.goyeau.kubernetes.client.IntOrString] = None,
  /* The protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP. */
  protocol: Option[String] = None
)

object NetworkPolicyPort {
  implicit lazy val encoder: Encoder.AsObject[NetworkPolicyPort] = deriveEncoder
  implicit lazy val decoder: Decoder[NetworkPolicyPort] = deriveDecoder
}
