package io.k8s.api.core.v1

/* Node is a worker node in Kubernetes. Each node will have a unique identifier in the cache (i.e. in etcd). */
import io.circe._
import io.circe.generic.semiauto._

case class Node(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* Spec defines the behavior of a node. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status */
  spec: Option[io.k8s.api.core.v1.NodeSpec] = None,
  /* Most recently observed status of the node. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status */
  status: Option[io.k8s.api.core.v1.NodeStatus] = None
)

object Node {
  implicit lazy val encoder: Encoder.AsObject[Node] = deriveEncoder
  implicit lazy val decoder: Decoder[Node] = deriveDecoder
}
