package io.k8s.api.core.v1

/* NodeAddress contains information for the node's address. */
import io.circe._
import io.circe.generic.semiauto._

case class NodeAddress(
  /* Node address type, one of Hostname, ExternalIP or InternalIP. */
  `type`: String,
  /* The node address. */
  address: String
)

object NodeAddress {
  implicit lazy val encoder: Encoder.AsObject[NodeAddress] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeAddress] = deriveDecoder
}
