package io.k8s.api.core.v1

/* NodeCondition contains condition information for a node. */
import io.circe._
import io.circe.generic.semiauto._

case class NodeCondition(
  /* Type of node condition. */
  `type`: String,
  /* Status of the condition, one of True, False, Unknown. */
  status: String,
  /* Last time we got an update on a given condition. */
  lastHeartbeatTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* Last time the condition transit from one status to another. */
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* Human readable message indicating details about last transition. */
  message: Option[String] = None,
  /* (brief) reason for the condition's last transition. */
  reason: Option[String] = None
)

object NodeCondition {
  implicit lazy val encoder: Encoder.AsObject[NodeCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeCondition] = deriveDecoder
}
