package io.k8s.api.core.v1

/* NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil. */
import io.circe._
import io.circe.generic.semiauto._

case class NodeConfigSource(
  /* ConfigMap is a reference to a Node's ConfigMap */
  configMap: Option[io.k8s.api.core.v1.ConfigMapNodeConfigSource] = None
)

object NodeConfigSource {
  implicit lazy val encoder: Encoder.AsObject[NodeConfigSource] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeConfigSource] = deriveDecoder
}
