package io.k8s.api.core.v1

/* A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm. */
import io.circe._
import io.circe.generic.semiauto._

case class NodeSelectorTerm(
  /* A list of node selector requirements by node's labels. */
  matchExpressions: Option[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]] = None,
  /* A list of node selector requirements by node's fields. */
  matchFields: Option[Seq[io.k8s.api.core.v1.NodeSelectorRequirement]] = None
)

object NodeSelectorTerm {
  implicit lazy val encoder: Encoder.AsObject[NodeSelectorTerm] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeSelectorTerm] = deriveDecoder
}
