package io.k8s.api.core.v1

/* NodeSpec describes the attributes that a node is created with. */
import io.circe._
import io.circe.generic.semiauto._

case class NodeSpec(
  /* If specified, the source to get node configuration from The DynamicKubeletConfig feature gate must be enabled for the Kubelet to use this field */
  configSource: Option[io.k8s.api.core.v1.NodeConfigSource] = None,
  /* Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966 */
  externalID: Option[String] = None,
  /* PodCIDR represents the pod IP range assigned to the node. */
  podCIDR: Option[String] = None,
  /* podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6. */
  podCIDRs: Option[Seq[String]] = None,
  /* ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID> */
  providerID: Option[String] = None,
  /* If specified, the node's taints. */
  taints: Option[Seq[io.k8s.api.core.v1.Taint]] = None,
  /* Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration */
  unschedulable: Option[Boolean] = None
)

object NodeSpec {
  implicit lazy val encoder: Encoder.AsObject[NodeSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeSpec] = deriveDecoder
}
