package io.k8s.api.core.v1

/* ObjectFieldSelector selects an APIVersioned field of an object. */
import io.circe._
import io.circe.generic.semiauto._

case class ObjectFieldSelector(
  /* Path of the field to select in the specified API version. */
  fieldPath: String,
  /* Version of the schema the FieldPath is written in terms of, defaults to "v1". */
  apiVersion: Option[String] = None
)

object ObjectFieldSelector {
  implicit lazy val encoder: Encoder.AsObject[ObjectFieldSelector] = deriveEncoder
  implicit lazy val decoder: Decoder[ObjectFieldSelector] = deriveDecoder
}
