package io.k8s.api.core.v1

/* PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes */
import io.circe._
import io.circe.generic.semiauto._

case class PersistentVolumeClaimSpec(
  /* AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1 */
  accessModes: Option[Seq[String]] = None,
  /* This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) * An existing custom resource that implements data population (Alpha) In order to use custom resource types that implement data population, the AnyVolumeDataSource feature gate must be enabled. If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. */
  dataSource: Option[io.k8s.api.core.v1.TypedLocalObjectReference] = None,
  /* Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources */
  resources: Option[io.k8s.api.core.v1.ResourceRequirements] = None,
  /* A label query over volumes to consider for binding. */
  selector: Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  /* Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1 */
  storageClassName: Option[String] = None,
  /* volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec. */
  volumeMode: Option[String] = None,
  /* VolumeName is the binding reference to the PersistentVolume backing this claim. */
  volumeName: Option[String] = None
)

object PersistentVolumeClaimSpec {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeClaimSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeClaimSpec] = deriveDecoder
}
