package io.k8s.api.core.v1

/* PersistentVolumeClaimTemplate is used to produce PersistentVolumeClaim objects as part of an EphemeralVolumeSource. */
import io.circe._
import io.circe.generic.semiauto._

case class PersistentVolumeClaimTemplate(
  /* The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here. */
  spec: io.k8s.api.core.v1.PersistentVolumeClaimSpec,
  /* May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation. */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
)

object PersistentVolumeClaimTemplate {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeClaimTemplate] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeClaimTemplate] = deriveDecoder
}
