package io.k8s.api.core.v1

/* PersistentVolumeStatus is the current status of a persistent volume. */
import io.circe._
import io.circe.generic.semiauto._

case class PersistentVolumeStatus(
  /* A human-readable message indicating details about why the volume is in this state. */
  message: Option[String] = None,
  /* Phase indicates if a volume is available, bound to a claim, or released by a claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase */
  phase: Option[String] = None,
  /* Reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI. */
  reason: Option[String] = None
)

object PersistentVolumeStatus {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeStatus] = deriveDecoder
}
