package io.k8s.api.core.v1

/* Represents a Photon Controller persistent disk resource. */
import io.circe._
import io.circe.generic.semiauto._

case class PhotonPersistentDiskVolumeSource(
  /* ID that identifies Photon Controller persistent disk */
  pdID: String,
  /* Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. */
  fsType: Option[String] = None
)

object PhotonPersistentDiskVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[PhotonPersistentDiskVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[PhotonPersistentDiskVolumeSource] = deriveDecoder
}
