package io.k8s.api.core.v1

/* PodCondition contains details for the current condition of this pod. */
import io.circe._
import io.circe.generic.semiauto._

case class PodCondition(
  /* Type is the type of the condition. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions */
  `type`: String,
  /* Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions */
  status: String,
  /* Last time we probed the condition. */
  lastProbeTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* Last time the condition transitioned from one status to another. */
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* Human-readable message indicating details about last transition. */
  message: Option[String] = None,
  /* Unique, one-word, CamelCase reason for the condition's last transition. */
  reason: Option[String] = None
)

object PodCondition {
  implicit lazy val encoder: Encoder.AsObject[PodCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[PodCondition] = deriveDecoder
}
