package io.k8s.api.core.v1

/* PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy. */
import io.circe._
import io.circe.generic.semiauto._

case class PodDNSConfig(
  /* A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed. */
  nameservers: Option[Seq[String]] = None,
  /* A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy. */
  options: Option[Seq[io.k8s.api.core.v1.PodDNSConfigOption]] = None,
  /* A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed. */
  searches: Option[Seq[String]] = None
)

object PodDNSConfig {
  implicit lazy val encoder: Encoder.AsObject[PodDNSConfig] = deriveEncoder
  implicit lazy val decoder: Decoder[PodDNSConfig] = deriveDecoder
}
