package io.k8s.api.policy.v1beta1

/* PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods */
import io.circe._
import io.circe.generic.semiauto._

case class PodDisruptionBudget(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* Specification of the desired behavior of the PodDisruptionBudget. */
  spec: Option[io.k8s.api.policy.v1beta1.PodDisruptionBudgetSpec] = None,
  /* Most recently observed status of the PodDisruptionBudget. */
  status: Option[io.k8s.api.policy.v1beta1.PodDisruptionBudgetStatus] = None
)

object PodDisruptionBudget {
  implicit lazy val encoder: Encoder.AsObject[PodDisruptionBudget] = deriveEncoder
  implicit lazy val decoder: Decoder[PodDisruptionBudget] = deriveDecoder
}
