package io.k8s.api.policy.v1beta1

/* PodSecurityPolicySpec defines the policy enforced. */
import io.circe._
import io.circe.generic.semiauto._

case class PodSecurityPolicySpec(
  /* seLinux is the strategy that will dictate the allowable labels that may be set. */
  seLinux: io.k8s.api.policy.v1beta1.SELinuxStrategyOptions,
  /* runAsUser is the strategy that will dictate the allowable RunAsUser values that may be set. */
  runAsUser: io.k8s.api.policy.v1beta1.RunAsUserStrategyOptions,
  /* supplementalGroups is the strategy that will dictate what supplemental groups are used by the SecurityContext. */
  supplementalGroups: io.k8s.api.policy.v1beta1.SupplementalGroupsStrategyOptions,
  /* fsGroup is the strategy that will dictate what fs group is used by the SecurityContext. */
  fsGroup: io.k8s.api.policy.v1beta1.FSGroupStrategyOptions,
  /* allowPrivilegeEscalation determines if a pod can request to allow privilege escalation. If unspecified, defaults to true. */
  allowPrivilegeEscalation: Option[Boolean] = None,
  /* AllowedCSIDrivers is an allowlist of inline CSI drivers that must be explicitly set to be embedded within a pod spec. An empty value indicates that any CSI driver can be used for inline ephemeral volumes. This is a beta field, and is only honored if the API server enables the CSIInlineVolume feature gate. */
  allowedCSIDrivers: Option[Seq[io.k8s.api.policy.v1beta1.AllowedCSIDriver]] = None,
  /* allowedCapabilities is a list of capabilities that can be requested to add to the container. Capabilities in this field may be added at the pod author's discretion. You must not list a capability in both allowedCapabilities and requiredDropCapabilities. */
  allowedCapabilities: Option[Seq[String]] = None,
  /* allowedFlexVolumes is an allowlist of Flexvolumes.  Empty or nil indicates that all Flexvolumes may be used.  This parameter is effective only when the usage of the Flexvolumes is allowed in the "volumes" field. */
  allowedFlexVolumes: Option[Seq[io.k8s.api.policy.v1beta1.AllowedFlexVolume]] = None,
  /* allowedHostPaths is an allowlist of host paths. Empty indicates that all host paths may be used. */
  allowedHostPaths: Option[Seq[io.k8s.api.policy.v1beta1.AllowedHostPath]] = None,
  /* AllowedProcMountTypes is an allowlist of allowed ProcMountTypes. Empty or nil indicates that only the DefaultProcMountType may be used. This requires the ProcMountType feature flag to be enabled. */
  allowedProcMountTypes: Option[Seq[String]] = None,
  /* allowedUnsafeSysctls is a list of explicitly allowed unsafe sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of allowed sysctls. Single * means all unsafe sysctls are allowed. Kubelet has to allowlist all allowed unsafe sysctls explicitly to avoid rejection.
  
  Examples: e.g. "foo&#47;*" allows "foo/bar", "foo/baz", etc. e.g. "foo.*" allows "foo.bar", "foo.baz", etc. */
  allowedUnsafeSysctls: Option[Seq[String]] = None,
  /* defaultAddCapabilities is the default set of capabilities that will be added to the container unless the pod spec specifically drops the capability.  You may not list a capability in both defaultAddCapabilities and requiredDropCapabilities. Capabilities added here are implicitly allowed, and need not be included in the allowedCapabilities list. */
  defaultAddCapabilities: Option[Seq[String]] = None,
  /* defaultAllowPrivilegeEscalation controls the default setting for whether a process can gain more privileges than its parent process. */
  defaultAllowPrivilegeEscalation: Option[Boolean] = None,
  /* forbiddenSysctls is a list of explicitly forbidden sysctls, defaults to none. Each entry is either a plain sysctl name or ends in "*" in which case it is considered as a prefix of forbidden sysctls. Single * means all sysctls are forbidden.
  
  Examples: e.g. "foo&#47;*" forbids "foo/bar", "foo/baz", etc. e.g. "foo.*" forbids "foo.bar", "foo.baz", etc. */
  forbiddenSysctls: Option[Seq[String]] = None,
  /* hostIPC determines if the policy allows the use of HostIPC in the pod spec. */
  hostIPC: Option[Boolean] = None,
  /* hostNetwork determines if the policy allows the use of HostNetwork in the pod spec. */
  hostNetwork: Option[Boolean] = None,
  /* hostPID determines if the policy allows the use of HostPID in the pod spec. */
  hostPID: Option[Boolean] = None,
  /* hostPorts determines which host port ranges are allowed to be exposed. */
  hostPorts: Option[Seq[io.k8s.api.policy.v1beta1.HostPortRange]] = None,
  /* privileged determines if a pod can request to be run as privileged. */
  privileged: Option[Boolean] = None,
  /* readOnlyRootFilesystem when set to true will force containers to run with a read only root file system.  If the container specifically requests to run with a non-read only root file system the PSP should deny the pod. If set to false the container may run with a read only root file system if it wishes but it will not be forced to. */
  readOnlyRootFilesystem: Option[Boolean] = None,
  /* requiredDropCapabilities are the capabilities that will be dropped from the container.  These are required to be dropped and cannot be added. */
  requiredDropCapabilities: Option[Seq[String]] = None,
  /* RunAsGroup is the strategy that will dictate the allowable RunAsGroup values that may be set. If this field is omitted, the pod's RunAsGroup can take any value. This field requires the RunAsGroup feature gate to be enabled. */
  runAsGroup: Option[io.k8s.api.policy.v1beta1.RunAsGroupStrategyOptions] = None,
  /* runtimeClass is the strategy that will dictate the allowable RuntimeClasses for a pod. If this field is omitted, the pod's runtimeClassName field is unrestricted. Enforcement of this field depends on the RuntimeClass feature gate being enabled. */
  runtimeClass: Option[io.k8s.api.policy.v1beta1.RuntimeClassStrategyOptions] = None,
  /* volumes is an allowlist of volume plugins. Empty indicates that no volumes may be used. To allow all volumes you may use '*'. */
  volumes: Option[Seq[String]] = None
)

object PodSecurityPolicySpec {
  implicit lazy val encoder: Encoder.AsObject[PodSecurityPolicySpec] = deriveEncoder
  implicit lazy val decoder: Decoder[PodSecurityPolicySpec] = deriveDecoder
}
